package com.agilex.healthcare.veteranappointment.testutility;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.XpathHelper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Document;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@SuppressWarnings("unchecked")
public class IntegrationTestConfiguration {

	public static final String CONFIGURATION_FILENAME = "integrationApplicationContext.xml";
	private static Map<String, String> properties = null;
	private static BeanFactory factory;

	static {
		factory = new ClassPathXmlApplicationContext(new String[] { CONFIGURATION_FILENAME });
		properties = (Map<String, String>) factory.getBean("configProperties");
	}

	public static Patient getPatient(String patientKey) {
		return (Patient) factory.getBean(patientKey);
	}

	public static Patient getTestPatient() {
		return getPatient("patientYounger");
	}

	public static Patient getTestInpatient() {
		return getPatient("testInpatient");
	}

	public static Patient getPatientSmithWithSSN() {
		return getPatient("patientSmithWithSSN");
	}

	public static Patient getTestPatientWithoutMiddleName() {
		return getPatient("patientWithoutMiddleName");
	}
	
	public static Patient getProdTestPatient() {
		return getPatient("prodTestPatient");
	}

	public static Patient getProdTestPatientWithMiddleName() {
		return getPatient("prodTestPatientWithMiddleName");
	}

	public static Patient getTestPatientWithSpaceInName() {
		return getPatient("patientWithSpaceInName");
	}

	public static String getMobileHealthServerBaseUri() {
		return getProperty("VeteranAppointmentRequestServiceBaseURI");
	}

	public static URI getHealthAdapterResourceDirectoryUri() {
		URI resourceDirectory = UriBuilder.fromUri(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("public").path("resource-directory").build();
		return resourceDirectory;
	}
	
	public static URI getResourceUri(String resourceTitle) {
		Client jerseyClient = ClientBuilder.newClient();
		Document resources = jerseyClient.target(IntegrationTestConfiguration.getHealthAdapterResourceDirectoryUri()).request().get(Document.class);
		return XpathHelper.getUri(resources, "//item[title='" + resourceTitle +  "']/link");
	}


	public static String getMHPAuthorizeURI() {
		return getProperty("MHPAuthorizeURI");
	}

	public static String getMHPTokenURI() {
		return getProperty("MHPTokenURI");
	}

	public static String getMHBaseURI() {
		return getProperty("MHPBaseURI");
	}

	public static String getDevBaseServerUri() {
		return getProperty("cih-dev-server-url");
	}

	private static String getProperty(String key) {
		return properties.get(key);
	}

	public static Patient getTestPatientWithNoData() {
		return getPatient("patientHealthy");
	}

	public static Allergy getTestAllergy() {
		return (Allergy) factory.getBean("testAllergy");
	}

	public static Patient getMedPatient() {
		return getPatient("patientMed");
	}

	public static Medication getOutpatientMedication() {
		return (Medication) factory.getBean("patientMed.outpatientMed");
	}

	public static Medication getInpatientMedication() {
		return (Medication) factory.getBean("patientMed.inpatientMed");
	}

	public static Patient getLabPatient() {
		return getPatient("patientLab");
	}

	public static Patient getLabPatientWithGroups() {
		return getPatient("patientLabWithGroups");
	}

	public static LabResult getLabPatientTestLab1() {
		return (LabResult) factory.getBean("patientLab.testLab1-recent");
	}

	public static LabResult getLabPatientTestLab2() {
		return (LabResult) factory.getBean("patientLab.testLab2-recent");
	}

	public static LabResult getLabPatientTestLabAbnormal() {
		return (LabResult) factory.getBean("patientLab.testLabAbnormal");
	}

	public static LabResult getLabPatientTestLabNormal() {
		return (LabResult) factory.getBean("patientLab.testLabNormal");
	}

	public static LabResult getLabResultStandardReferenceRange() {
		return (LabResult) factory.getBean("patientLab.testLabNormal");
	}

	public static LabResult getLabResultLessThanUpperReferenceRange() {
		return (LabResult) factory.getBean("patientLab.testLabLessThanUpperReferenceRange");
	}

	public static Patient getFirstSmithPatient() {
		return getPatient("patientFirstSmith");
	}

	public static Patient getPatientWithValidDOB() {
		return getPatient("patientWithValidDOB");
	}

	public static Patient getPatientWithDOBMonthYear() {
		return getPatient("patientWithDOBMonthYear");
	}

	public static Patient getPatientWithDOBYear() {
		return getPatient("patientWithDOBYear");
	}

	public static HashMap<String, String> getAppointmentData() {
		return (HashMap<String, String>) factory.getBean("expectedAppointmentData", HashMap.class);
	}

	public static Set<String> getExpectedGroupsOrderForPateintId() {
		return (Set<String>) factory.getBean("expectedGroupsOrderForPatteintId", Set.class);
	}

	public static Set<String> getExpectedLabTestIdsOrderForCBCProfileGroup() {
		return (Set<String>) factory.getBean("expectedLabTestIdsInCBCProfileGroup", Set.class);
	}

	public static Problem getProblem() {
		return (Problem) factory.getBean("testProblem", Problem.class);
	}

	public static Patient getPatientForInpatientMed() {
		return getPatient("testPatientInpatientMed");
	}

}
